require( "quest/m2_kitchen/convout.lua" );
combine_speech_tables();

round_num = 
{
	1, -- round one
};

initial_setup = true;
local activity_complete = false;

local recipe = nil;
local strikethroughs = { };
local ingredients = { };
local buttons = { };
local buttonsPressedInSequence = 0;
local list_close = nil;
local dimmer = nil;
local cake = nil;
local cakeDone = false;
local currentContainer = nil;

local CakeOMaticEntryOffset = { x = 450, y = 305 };

local kitchenActivityInfo = 
{
	{ name = "fridge", closed = "fridgeClosed", open = "fridgeOpen" },
	{ name = "freezer", closed = "freezerClosed", open = "freezerOpen" },
	{ name = "cabinet1", closed = "cabinet1Closed", open = "cabinet1Open" },
	{ name = "cabinet2", closed = "cabinet2Closed", open = "cabinet2Open" },
	{ name = "cabinet3", closed = "cabinet3Closed", open = "cabinet3Open" },
	{ name = "cabinet4", closed = "cabinet4Closed", open = "cabinet4Open" },
	{ name = "cabinet5", closed = "cabinet5Closed", open = "cabinet5Open" },
	{ name = "cabinet6", closed = "cabinet6Closed", open = "cabinet6Open" },
	{ name = "drawer", closed = "drawerClosed", open = "drawerOpen" }
}

local buttonInfo = 
{
	image =
	{
		{
			up = "cake_button_1_normal";
			over = "cake_button_1_rollover";
			down = "cake_button_1_down";
		},
		{
			up = "cake_button_2_normal";
			over = "cake_button_2_rollover";
			down = "cake_button_2_down";
		},
		{
			up = "cake_button_3_normal";
			over = "cake_button_3_rollover";
			down = "cake_button_3_down";
		},
	};
	correctSequence = { 1, 1, 2, 2, 3, 3, 2, 2, 1, 1 };
}

-- synch this with m2_kitchen.cabinetlua and ingredientNames below
local recipeInfo =
{
	ingredients = { "Milk", "Frozen Raspberries", "Flour", "Applesauce", "Sauerkraut", "Baking Powder", "Oyster Sauce", "Sugar", "6 Double Yolk Eggs", "Minty Mint Crisps" };
}

local ingredientNames = 
{
	"milk", "raspberries", "flour", "applesauce", "sauerkraut", "powder", "oyster", "sugar", "eggs", "cookies"
};

function show_default_help_panel_text()
	local clicked_list = quest_added("get_eggs");
	local got_cookies = quest_complete("get_cookies");
	local got_eggs = quest_complete("get_eggs");
	local got_video = quest_added("use_cake_instructions");
	local watched_video = quest_complete("use_cake_instructions");
	local found_ingredients = quest_complete("get_ingredients");
	local help_panel_text = "";

	if found_ingredients then
		if not clicked_list then 
			local tutorial_arrow = safe_spawn_actor(tutorial_arrow_spec);
			tutorial_arrow:LoadImage("arrow_2");
			
			if not got_cookies then
				help_panel_text = "kitchen_need_cookies_eggsA";
			else
				help_panel_text = "kitchen_need_eggsA";
			end
		else
			if not got_cookies and not got_eggs then
				help_panel_text = "kitchen_need_cookies_eggsB";
			elseif got_cookies and not got_eggs then
				help_panel_text = "kitchen_need_eggsB";
			elseif not got_cookies and got_eggs then
				help_panel_text = "kitchen_need_cookies";
			elseif not got_video then
				help_panel_text = "kitchen_need_vhs";
			elseif not watched_video then
				help_panel_text = "kitchen_need_vcr";
			else -- say nothing?
				help_panel_text = "kitchen_enter_code";
			end
		end
	else
		help_panel_text = "start_kitchen";
	end
	
	if scene.HELP_PANEL then
		help_panel_say_raw( scene:grabstring( help_panel_text ) ); 
	end
end

local tutorial_progress = 0;
local tutorial_in_progress = false;

function setup_tutorial()
	for i = 1,table.getn(kitchenActivityInfo) do
		scene[kitchenActivityInfo[i].name]:DumpZone();
	end
	
	for i = 1, 3 do	
		scene[ "button" .. tostring( i ) ]:DumpZone();
	end
	
	scene["list"]:DumpZone();
end

function do_tutorial()
	tutorial_progress = 1;
	tutorial_in_progress = true;
	
	help_panel_say_raw(scene:grabstring("tutorial_1"));
	coroutine.yield(RESUME.ON_CLICK);
	
	scene:Spawn(tutorial_arrow_spec);
	help_panel_say_raw(scene:grabstring("tutorial_2"));
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
	
	scene[kitchenActivityInfo[1].name]:LoadZone( kitchenActivityInfo[1].name .. "Closed" );
	
	while tutorial_progress < 2 do
		delay(1);
	end;
	
	scene[tutorial_arrow_spec.name]:Expire();
	scene.FLO:SetMode(MODE.CUTSCENE);
	help_panel_say_raw(scene:grabstring("tutorial_3"));
	coroutine.yield(RESUME.ON_CLICK);
	
	show_default_help_panel_text();

	-- reload the meshes
	for i = 1,table.getn(kitchenActivityInfo) do
		scene[kitchenActivityInfo[i].name]:LoadZone( kitchenActivityInfo[i].name .. "Closed" );
	end
	
	for i = 1, 3 do	
		scene[ "button" .. tostring( i ) ]:LoadZone("button" .. i);
	end
	
	scene["list"]:LoadZone("shopping_list");
	
	tutorial_in_progress = false;
	
	game:Set("kitchen_activity_tutorial", 1);
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
end

function spawn_kitchen()
	for i, info in pairs(kitchenActivityInfo) do
		if ( i < 9 ) then 
			local kitchen_item_spec = get_kitchen_item_spec( info.name, info.closed, info.open, i );
			scene:Spawn( kitchen_item_spec );
		else
			local drawer_spec = get_drawer_spec( info.name, info.closed, info.open, i );
			scene:Spawn( drawer_spec );
		end
	end
	local dimmer_spec = get_generic_item_spec( "dimmer", "dimming_layer" );
	dimmer = scene:Spawn( dimmer_spec );	
	dimmer:SetAlpha( 0 );
end

function goto_drawer(flo)
	flo:SetMode(MODE.CUTSCENE);
	dimmer:SetAlpha( 1 );
	scene.BACK_BUTTON:SetAlpha(0);
	scene.BACK_BUTTON:SayRaw("");
	scene.PAUSE_BUTTON_HELP:SetAlpha(0);
	scene:ChainToSubScene( "m2_kitchendrawer" );
	wait_subscene();
	scene.BACK_BUTTON:SetAlpha(1);
	scene.BACK_BUTTON:SayRaw(scene:grabstring("back"));
	scene.PAUSE_BUTTON_HELP:SetAlpha(1);
	dimmer:SetAlpha( 0 );
	currentContainer:SetAlpha(0);
	currentContainer = nil;
	
	if BAG_INV:CheckInventory("vhstape") then
		if quest_added("get_cake_instructions") then
			complete_quest("get_cake_instructions", false);
		end
	
		add_quest("use_cake_instructions", true, true);
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function get_drawer_spec( _name, _imageClosed, _imageOpen, _index )
	return
	{
		name = _name;
		halo = _name .. "Closed";
		gfx = { image = _name .. "_open" };
		
		command = function(actor)
			actor:SetAlpha( 0 );
			actor:SetDepthValue( 2 );
			
			actor.on_click = function(flo, item)
				if ( game:Get( "got_video" ) == 1 ) then
					return;
				else
					currentContainer = item;
					flo:StartProc(goto_drawer);
				end
			end
			
			actor.point_at_fn = function(actor, enter)
				if scene.FLO:GetMode() ~= MODE.CUTSCENE then
					if enter then					
						sfx:PlaySFX( "audio/sfx/bakery_drawer_open", false );
						if ( game:Get( "got_video" ) == 1 ) then
							help_panel_say_raw( scene:grabstring( "already_got_ingredient" ) );
						else
							actor:SetAlpha( 1 );
							show_default_help_panel_text();
						end
					else
						sfx:PlaySFX( "audio/sfx/bakery_drawer_close", false );
						actor:SetAlpha( 0 );
						show_default_help_panel_text();
					end
				end
			end		
		end;
	}
end

function goto_cabinet(flo)
	flo:SetMode(MODE.CUTSCENE);
	dimmer:SetAlpha( 1 );
	scene.BACK_BUTTON:SetAlpha(0);
	scene.PAUSE_BUTTON_HELP:SetAlpha(0);
	scene.BACK_BUTTON:SayRaw("");
	scene:ChainToSubScene( "m2_kitchencabinet" );
	wait_subscene();
	scene.BACK_BUTTON:SetAlpha(1);
	scene.BACK_BUTTON:SayRaw(scene:grabstring("back"));
	scene.PAUSE_BUTTON_HELP:SetAlpha(1);
	dimmer:SetAlpha( 0 );
	currentContainer:SetAlpha(0);
	currentContainer = nil;
	
	for i = 1, 3 do	
		scene[ "button" .. tostring( i ) ]:DumpZone();
	end
	
	for i = 1, 8 do
		if ( check_have_ingredient( i ) and game:Get( "Added " .. recipeInfo.ingredients[i] ) ~= 1 ) then			
			if tutorial_progress == 1 then
				game:Set( "Added " .. recipeInfo.ingredients[i], 1 );
				game:Set("kitchen_activity_tutorial", 1);
				game:SaveGame();
			end
			AddItemToCakeOMatic( i );
			UpdateRecipe();
			sfx:PlaySFX( "audio/sfx/checklist_cross_off", false );
		end	
	end
	
	-- save progress
	game:SaveGame();
	
	-- check if we've found all the ingredients in the kitchen
	local ingredients_found = 0;
	for i = 1, 8 do
		if check_have_ingredient( i ) then
			ingredients_found = ingredients_found + 1;
		end
	end
	
	if ingredients_found == 8 then
		complete_quest("get_ingredients", true, true);
		wait_subscene();
	end
	
	-- increment tutorial progress if we have to, harmless if we don't
	tutorial_progress = tutorial_progress + 1;
	
	--coroutine.yield(RESUME.ON_CLICK);
	
	show_default_help_panel_text();
	
	for i = 1, 3 do	
		scene[ "button" .. tostring( i ) ]:LoadZone("button" .. i);
	end
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function get_kitchen_item_spec( _name, _imageClosed, _imageOpen, _index )
	return
	{
		name = _name;
		halo = _name .. "Closed";
		gfx = { image = _name .. "_open" };
		
		command = function(actor)
			actor:SetAlpha( 0 );
			actor:SetDepthValue( 2 );
			
			if _index > 2 then -- so, not fridge or freezer
				actor.level = game:Get("fridge_puzzle_level_" .. _index);
			else
				actor.level = _index;
			end
			
			actor.on_click = function(flo, item)
				if ( actor.level > 0 and game:Get( "Has " .. recipeInfo.ingredients[actor.level] ) == 1 ) then
					help_panel_say_raw( scene:grabstring( "already_got_ingredient" ) );
					return;
				else
					if actor.level < 1 then -- unassigned cabinet level
						-- cabinets increase in difficulty based on the order they are explored
						local currentLevel = game:Get("fridge_puzzle_level_current");
						
						if currentLevel < 1 then
							currentLevel = 1;
						else
							currentLevel = currentLevel + 1;
						end
						
						actor.level = 2 + currentLevel;
						
						game:Set("fridge_puzzle_level_current", currentLevel);
						game:Set("fridge_puzzle_level_" .. _index, actor.level);
					end
					game:Set( "fridge_puzzle_index", actor.level );
					currentContainer = item;
					flo:StartProc(goto_cabinet);
				end
			end
			
			actor.point_at_fn = function(actor, enter)	
				if scene.FLO:GetMode() ~= MODE.CUTSCENE then
					if enter then
						if ( actor.level < 1 or game:Get( "Has " .. recipeInfo.ingredients[actor.level] ) ~= 1 ) then
							actor:SetAlpha( 1 );
							if _index < 3 then -- HACK, this means fridge or freezer
								sfx:PlaySFX( "audio/sfx/bakery_fridge_open.ogg", false );
							else
								sfx:PlaySFX( "audio/sfx/bakery_cabinet_open.ogg", false );
							end
							if not tutorial_in_progress then
								show_default_help_panel_text();
							end
						end
					else
						if ( actor.level < 1 or game:Get( "Has " .. recipeInfo.ingredients[actor.level] ) ~= 1 ) then
							if _index < 3 then -- HACK, this means fridge or freezer
								sfx:PlaySFX( "audio/sfx/bakery_fridge_close.ogg", false );
							else
								sfx:PlaySFX( "audio/sfx/bakery_cabinet_close.ogg", false );
							end
							actor:SetAlpha( 0 );
						end
						if not tutorial_in_progress then
							show_default_help_panel_text();
						end
					end
				end
			end		
		end;
	}
end

function spawn_recipe()
	local recipe_depth = 485;
	BAG_INV:RemoveInventory("recipe");
	local recipe_spec = get_generic_item_spec( "recipe", "recipe", recipe_depth );
	recipe = scene:Spawn( recipe_spec );
	for index, ingredient in pairs(recipeInfo.ingredients) do		
		local strikethrough_spec = get_generic_item_spec( "strikethrough" .. tostring( index ), "strikethrough", recipe_depth + index );
		strikethroughs[index] = scene:Spawn( strikethrough_spec );
		strikethroughs[index]:SetAlpha( 0 );
	end
	UpdateRecipe();
	
	if game:Get("first_time_kitchen") < 1 then
		local scroll_move = 400;
		local accel = 0.5;
		local speed = -20;
		
		move_actor_y(recipe, scroll_move);
		for index, ingredient in pairs(recipeInfo.ingredients) do		
			move_actor_y(strikethroughs[index], scroll_move);
		end
		
		delay(30);
		
		while speed < 0 do
			move_actor_y(recipe, speed);
			for index, ingredient in pairs(recipeInfo.ingredients) do		
				move_actor_y(strikethroughs[index], speed);
			end
			speed = speed + accel;
			delay(1);
		end
		
	end
end

function spawn_ingredients()	
	local cake_spec = get_generic_item_spec( "cake", "cake", 495);
	cake = scene:Spawn( cake_spec );
	cake:SetAlpha( 0 );
end

function UpdateRecipe()
	recipe:ModifySaySpec
	{
		color = { a = 1, r = 0, g = 0, b = 0 },
		y = 230,
		x = 610,
		w = 200,
		h = 300,
		bubble = false,
		fixed = true,
		outline_size = 0,
		font = "fonts/garamondpremierpro.mvec"; 
		halign = HALIGN.LEFT,
		anchor = ANCHOR.CENTER
	};
	recipe:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
	recipe:SayRaw( scene:grabstring( "ingredients_list" ) );
	for index, ingredient in pairs(recipeInfo.ingredients) do		
		if ( game:Get( "Has " .. recipeInfo.ingredients[index] ) == 1 ) then
			strikethroughs[index]:JumpToPoint( { x = 610, y = 280 + recipe:GetPosition().y + 20 * index } );
			strikethroughs[index]:SetAlpha( 1 );
		else
			strikethroughs[index]:SetAlpha( 0 );
		end
	end
end

function get_generic_item_spec( _name, _image, _depth )
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };		
		
		command = function(actor)
			actor:SetAlpha( 1 );
			if _depth ~= nil then
				actor:SetDepthValue( _depth );
			end
		end;
	}
end

function spawn_list()
	local list_spec = get_list_spec( "list", "shopping_list" );
	scene:Spawn( list_spec );
	list_spec = get_list_close_spec( "list_close", "shopping_list_close" );
	list_close = scene:Spawn( list_spec );
end

function show_list(flo)
	flo:SetMode(MODE.CUTSCENE);
	list_close:SetAlpha( 1 );
	safe_kill_actor(scene.TUTORIAL_ARROW);
	list_close:Say( "shopping_list" );
	
	help_panel_say_raw(scene:grabstring( "out_of_eggs_and_cookies" ));
	
	if not quest_added( "get_eggs" ) then
		coroutine.yield(RESUME.ON_CLICK);
		add_quest("get_eggs", false);
		add_quest("get_cookies", true, true); -- lets assume we always add these at the same time
		wait_subscene();
	end
	
	coroutine.yield(RESUME.ON_CLICK);
	list_close:SetAlpha( 0 );
	list_close:SayRaw( "" );
	show_default_help_panel_text();
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function get_list_spec( _name, _image )
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };		
		
		command = function(actor)
			actor:SetAlpha( 1 );
			actor:SetDepthValue(100);
	
			actor.on_click = function(flo, item)
				flo:StartProc(show_list);
			end
		end;
	}
end

function get_list_close_spec( _name, _image )
	return
	{
		name = _name;
		gfx = { image = _image };		
		
		command = function(actor)
			actor:SetAlpha( 0 );
			actor:SetDepthValue( 510 );
			
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 190,
				x = 340,
				w = 200,
				h = 300,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				halign = HALIGN.LEFT,
				anchor = ANCHOR.CENTER
			};
		end;
	}
end

cake_machine_spec = 
{
	name = "CAKE_MACHINE";
	gfx = { anim = "anim/m2_kitchen/cake_machine" };
	
	command = function(actor)
		actor:SetDepthValue(490);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Closed");
	end;
}

cake_machine_overlay_spec = 
{
	name = "CAKE_MACHINE_OVERLAY";
	gfx = { image = "cake_machine" };
	
	command = function(actor)
		actor:SetDepthValue(505);
	end;
}

function spawn_cakeMachine()
	scene:Spawn(cake_machine_spec);
	
	for i = 1, 3 do	
		local button_spec = get_button_spec( "button" .. tostring( i ), i );
		buttons[i] = scene:Spawn( button_spec );
	end		
end

function button_up_delay(button, index)
	button:StartProc(
		function(actor)
			delay(5);
			actor:LoadImage( buttonInfo.image[index].up );
		end
	);
end;

function get_button_spec( _name, _index )
	return
	{
		name = _name;
		halo = "button" .. _index;
		gfx = { image = buttonInfo.image[_index].up };		
		
		command = function(actor)
			actor:SetAlpha( 1 );
			
			actor.on_click = function(flo, item)
				sfx:PlaySFX( "audio/sfx/cake_machine_button", false );
				actor:LoadImage( buttonInfo.image[_index].down );
				if ( HasAllIngredients() == true ) then
					if quest_complete("use_cake_instructions") then
						if ( buttonInfo.correctSequence[buttonsPressedInSequence + 1] == _index ) then
							buttonsPressedInSequence = buttonsPressedInSequence + 1;
							if ( buttonsPressedInSequence == 10 ) then
								cakeDone = true;
							end							
						else
							buttonsPressedInSequence = 0;
						end
					elseif ( game:Get( "got_video" ) ~= 1 ) then
						help_panel_say_raw( scene:grabstring( "need_video" ) );
						
						if not quest_added("get_cake_instructions") then
							flo:StartProc( function(flo) coroutine.yield(RESUME.ON_CLICK); add_quest("get_cake_instructions", true, true); end );
						end
					else
						help_panel_say_raw( scene:grabstring( "need_to_watch_video" ) );
					end
				else
					help_panel_say_raw( scene:grabstring( "need_ingredients" ) );
				end
				button_up_delay(item, _index);
			end
			
			actor.point_at_fn = function(actor, enter)				
				if enter then
					actor:LoadImage( buttonInfo.image[_index].over );
				else
					actor:LoadImage( buttonInfo.image[_index].up );
				end
			end		
		end;
	}
end

function HasAllIngredients()
	for i = 1, 10 do
		if ( game:Get( "Has " .. recipeInfo.ingredients[i] ) ~= 1 ) then
			return false;
		end		
	end
	return true;
end

function check_have_cookies()
	if ( BAG_INV:CheckInventory("cookies") ) then
		scene.FLO:SetMode(MODE.CUTSCENE);
		run_super_conversation( scene.FLO, "has_cookies_already" );	
		BAG_INV:RemoveInventory("cookies");
		game:Set( "Has " .. recipeInfo.ingredients[10], 1 );
		return true;
	end
	return false;
end

function check_have_eggs()
	if ( BAG_INV:CheckInventory("egg") == true and game:Get("egg_count") == 6 ) then
		scene.FLO:SetMode(MODE.CUTSCENE);
		run_super_conversation( scene.FLO, "has_eggs_already" );	
		BAG_INV:RemoveInventory("egg");
		game:Set( "Has " .. recipeInfo.ingredients[9], 1 );
		return true;
	end
	return false;
end

function AddItemToCakeOMatic( index )
	scene.CAKE_MACHINE:PlayAnim("Open");
	sfx:PlaySFX( "audio/sfx/cake_machine_open", false );
	local popupName = "";
	
	game:Set( "Added " .. recipeInfo.ingredients[index], 1 );
	help_panel_say_raw(scene:grabstring("help_add_item_" .. index));
	
	if index < 9 then
		popupName = "popup/pop_kitchen_item" .. index;
	elseif index == 9 then
		popupName = "popup/pop_inv_egg";
	elseif index == 10 then
		popupName = "popup/pop_inv_cookies";
	end
	
	scene:Spawn(cake_machine_overlay_spec);
	do_item_fly(scene.FLO, popupName, { x = CakeOMaticEntryOffset.x, y = CakeOMaticEntryOffset.y + 125 }, index);
	scene.CAKE_MACHINE_OVERLAY:Expire();
	
	scene.CAKE_MACHINE:PlayAnim("Close");
end

function do_item_fly(player, item_image, desiredLocation, index)
	local inventory_popup = scene:Spawn
	{
		name = "INVENTORY_POPUP_" .. index;
		
		command = function(actor)
			actor:SetDepthValue(495);
		end;
	};
	
	if item ~= "" then
		local popupScale = 1;
		local moveTime = 57;
		local flashFrequency = 10;
		local flashTime = 40;
		local desiredSize = 45; -- inventory size = 53x53
		local imageStr = item_image;
		
		-- load the popup image
		inventory_popup:LoadImage(imageStr);
		
		-- if we have the popup image, do the fancy effects
		if inventory_popup:HasGraphics() then
			inventory_popup:SetScale(popupScale);
			
			local imageSize = inventory_popup:GetImageSize();
			local popupLocation = { x = 400 - (imageSize.x / 2), y = 250 - (imageSize.y / 2) };
			local desiredScale = desiredSize / (math.max(imageSize.x, imageSize.y));
			local ySpeed = -15;
			local yAccel = 0.75;
			
			inventory_popup:JumpToPoint(popupLocation)
			
			desiredLocation.x = desiredLocation.x - ((imageSize.x / 2) * desiredScale);
			desiredLocation.y = desiredLocation.y - ((imageSize.y / 2) * desiredScale);
		
			local timer = 0;
			
			delay(30);
			
			-- move to inventory location
			while timer < moveTime do
				local newPoint = { x = 0, y = 0 };
				local delta = timer / moveTime;
				
				newPoint.x = popupLocation.x + ((desiredLocation.x - popupLocation.x) * delta);
				newPoint.y = math.min(inventory_popup:GetPosition().y + ySpeed, desiredLocation.y);
				inventory_popup:JumpToPoint(newPoint);
				inventory_popup:SetScale(popupScale + ((desiredScale - popupScale) * delta));
				timer = timer + 1;
				ySpeed = ySpeed + yAccel;
				delay(1);
			end
			
			inventory_popup:SetAlpha(0);
		else
			coroutine.yield(RESUME.NOW);
		end
	end
			
	inventory_popup:Expire();
end

function cakeRise( item )
	scene.CAKE_MACHINE:PlayAnim("Open");
	wait_anim(scene.CAKE_MACHINE);
	
	scene:Spawn(cake_machine_overlay_spec);
	scene.FRONT_COUNTER:SetDepthValue(499);
	
	item:SetAlpha( 1 );
	item:JumpToPoint( { CakeOMaticEntryOffset.x-59, CakeOMaticEntryOffset.y + 40 } );
	local i = 0;
	while ( i < 185 ) do
		item:JumpToPoint{ x = CakeOMaticEntryOffset.x-59, y = CakeOMaticEntryOffset.y + 40 - i };	
		i = i + 2;
		delay( 1 );
	end
end

function check_have_ingredient( index )	
	if ( game:Get( "Has " .. recipeInfo.ingredients[index] ) == 1 ) then
		return true;
	end
	return false;
end

function game_loop()
	while cakeDone == false do
		delay(1);
	end
	scene.FLO:SetMode(MODE.CUTSCENE);
	sfx:PlaySFX( "audio/sfx/cake_machine_work", false );
	
	for i = 1, 3 do	
		scene[ "button" .. tostring( i ) ]:DumpZone();
		scene[ "button" .. tostring( i ) ]:SetAlpha(0);
	end
	
	scene.CAKE_MACHINE:PlayAnim("Working");
	wait_anim(scene.CAKE_MACHINE);
	
	for i = 1, 3 do	
		scene[ "button" .. tostring( i ) ]:LoadZone("button" .. i);
		scene[ "button" .. tostring( i ) ]:SetAlpha(0);
	end
	
	cakeRise( cake );
end

tutorial_arrow_spec = 
{
	name = "TUTORIAL_ARROW";
	gfx = { image = "arrow_1" };
	
	command = function(actor)
		actor:SetDepthValue(500);
	end;
}

function setup_activity()
	if initial_setup then
		initial_setup = false;
		coroutine.yield(RESUME.NOW);
	end

	if game:Get("first_time_kitchen") < 1 then
		spawn_recipe();
		game:Set("first_time_kitchen", 1);
	end
	
	BAG_INV:RemoveInventory("recipe");
	
	if ( game:Get( "Added " .. recipeInfo.ingredients[10] ) ~= 1 and check_have_cookies() ) then		
		AddItemToCakeOMatic( 10 );
		UpdateRecipe();
		sfx:PlaySFX( "audio/sfx/checklist_cross_off", false );
		complete_quest("use_cookies", true, true);
	end	
	
	if ( game:Get( "Added " .. recipeInfo.ingredients[9] ) ~= 1 and check_have_eggs() ) then
		AddItemToCakeOMatic( 9 );
		UpdateRecipe();
		sfx:PlaySFX( "audio/sfx/checklist_cross_off", false );
		complete_quest("use_eggs", true, true);
	end
	
	show_default_help_panel_text();
	
	if game:Get("kitchen_activity_tutorial") < 1 then
		do_tutorial();
	else
		scene.FLO:SetMode(MODE.FOLLOWCLICKS);
	end
	
	game_loop();
	activity_passed( scene.FLO );
	
	
--	if activityNum == 1 and activityRound == 1 then
--		help_panel_say_raw(scene:grabstring("tutorial_1"));
--	else
--		help_panel_say_raw(scene:grabstring("help_" .. tostring(activityRound) .. "_" .. tostring(activityNum)));
--	end
end;

function activity_passed(flo)
	activity_complete = true;
	
--	scene.HINT_BUTTON:Expire();
	scene.BACK_BUTTON:Expire();
	
	help_panel_say_raw( scene:grabstring( "finished_activity" ) );
		
	complete_quest( "cake", false);
	game:EarnAward("avenue-flo_weddingcake");
	complete_quest( "info_cake_code", true, true);
	
	game:Set( "cake_done", 1 );
	
	-- save progress
	game:SaveGame();	
	
	goto_scene( flo, "m2_bakery" );
end;

flo_spec =
{
	name = "FLO";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		--actor:SetMode(MODE.FOLLOWCLICKS); -- set in setup_activity();
	end;
};

function go_back(flo)
	goto_scene(flo, "m2_bakery");
end

front_counter_spec = 
{
	name = "FRONT_COUNTER";
	gfx = { image = "front_counter" };
	
	command = function(actor)
		actor:SetDepthValue(480);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/petspamusic.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		game:ClearInvUsage();
		
		scene:Spawn(flo_spec);
		
		spawn_kitchen();
		spawn_cakeMachine();
		spawn_ingredients();
		spawn_list();
		
		if game:Get("kitchen_activity_tutorial") < 1 then
			setup_tutorial();
		end
		
		if game:Get("first_time_kitchen") > 0 then
			spawn_recipe();	
		end
		
		if IsCheatMode() then
			-- testing data
			--game:Set("first_time_fitness", 0);
			--game:Set("mg_aerobics_activity_round", 2);
			--game:Set("got_video", 1);
			--complete_quest("use_cake_instructions");
			--BAG_INV:AddInventory(inv_desc_eggs);
			--BAG_INV:AddInventory(inv_desc_cookies);
			--game:Set("kitchen_activity_tutorial", 1);
		end
		
		fade_scene_up(true);
		lower_hud();
		spawn_help_panel();
		
--		spawn_button(hint_button_spec);
		
		setup_activity();
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces1",
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "front_counter", 480 },
		--{ "cake_machine", 505 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		scene_setup,
		front_counter_spec,
	};
};
